﻿using System;
using System.Collections.Generic;
using System.Text;
using CIA_CSS;
using CSS_User;

namespace IndianHealthService.BMXNet.EHR
{
    internal class BMXNetEhrSessionConnection : BMXNetSessionConnection
    {

        public override int SendTimeout
        {
            get { return 60000; }
            set {  }
        }

        public override int ReceiveTimeout
        {
            get { return 60000; }
            set { }
        }

        public override Encoding ConnectionEncoding
        {
            get
            {
                return System.Text.Encoding.Default;
            }
            set
            {
                ConnectionEncoding = value;
            }
        }


        public BMXNetEhrSessionConnection(BMXNetBroker aBroker):base(aBroker)
        {
        }

        
        public override void Close()
        {
            //Don't close the EHR's internal broker
            this.CiaSession = null;
        }

        public override bool IsConnected
        {
            get { return this.CiaSession != null; }
        }

        public override string GetLoginFacility(string aDuz)
        {
            return this.TransmitRPC("BMXGetFac", aDuz);
        }

        public static BMXNetEhrSessionConnection OpenOn(BMXNetBroker aBroker,ICSS_Session aCssSession, ICSS_User aCiaUser)
        {
            BMXNetEhrSessionConnection answer = new BMXNetEhrSessionConnection(aBroker);
            answer.CiaSession= aCssSession;
            answer.CiaUser=aCiaUser;
            return answer;
        }

        private ICSS_User _ciaUser;

        public ICSS_User CiaUser
        {
            get { return _ciaUser; }
            set
            {
                _ciaUser = value;
                if (value != null)
                {                    
                    this.UserName = value.Name;
                    this.DUZ = value.Handle.ToString();
                }
            }
        }

        private ICSS_Session _ciaSession;

        public ICSS_Session CiaSession
        {
            get { return _ciaSession; }
            set { _ciaSession = value;}
        }
 
        protected override string SendReceiveString(string sendString, string multi)
        {
            return this.DecodeReceiveString(
                this.CiaSession.CallRPCText(
                    "BMXRPC^BMX CIA", 
                    this.EncodeSendString(sendString, this.EncodeSendString(this.EncryptionProvider.Encrypt(this.AppContext==null ? "" : this.AppContext),multi)))).Trim();
        }
    

    }
}
